close all; clc; clearvars;
% input: Nshift, T1, T2, TR
% output: FA_opt;

Nshift = 30; % L2, phase increment number in PISS expriment
band_num  = Nshift/2;

M = 300;     % For signal simulation only. Simulation points for phi [-pi, pi].
M = round(M/2)*2;     % must be even.
M = ceil(M/Nshift)*Nshift;     % divisible by nshift.

T1 = 3283; % ms
T2 = 555.3*2; % ms
TR = 2.56; % ms

% number of points and method of filter calculation algorithm
% ================================================================
% filt_struct.Nfilt = M;       % points of FIR filter.
filt_struct.Nfilt = 300;       % points of FIR filter.
filt_struct.Nfilt = min(max(filt_struct.Nfilt, 100), M);       % limit to [100, M].
Nfilt = filt_struct.Nfilt;       % lc calculation method.
% Nfilt = Nfilt - 1 + mod(Nfilt, 2);     % prefer Nfilt is odd.
% filt_struct.method = 'time';
filt_struct.method = 'phi';

RF_phase = 0;

plot_data = 1; % plot_data > 0 means plot figure

[FA_opt, opt_filters, res] = find_flip(band_num, M, Nshift, T1, T2, TR, filt_struct, RF_phase, plot_data);
